#ifndef CE2_ECPKI_ELGAMAL_H
#define CE2_ECPKI_ELGAMAL_H

/*
 *  Object name     :  CE2_ECPKI_ELGAMAL.h
   *  State           :  %state%
   *  Creation date   :  02.02.2006
   *  Last modified   :  %modify_time%
   */
/** @file
 * \brief This module defines the API that supports EC Elgamal encryption and
 *        decryption operations 
 *
 * \version CE2_ECPKI_ELGAMAL.h#1:cinc:1
 * \author R.Levin
 * \remarks Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
 */
 

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**
****************************************************************
* Function Name: 
*  CE2_DX_ECPKI_ELGAMAL_Encrypt
*
* Inputs:
* @param ReceiverUserPublKey_ptr [in] - A pointer to receiver public key 
*                           (key in little endian)
* @param MessageIn_ptr [in] - A pointer to message to be encrypted (message in big endian).
* @param MessageInSizeBytes [in] - A size of incoming message in bytes. The size must be
*                       MessageInSizeBytes =< ModulusSizeInBytes -  1.
*                       Note: in case CE2_ECPKI_DomainID_secp521r1 
*                       MessageInSizeBytes =< ModulusSizeInBytes -  2.
* @param EncrMessageOut_ptr [out] - A pointer to buffer for encrypted message.
* @param EncrMessageOutSize_ptr [in\out] - A pointer to output message size.
* @param IsEphemerKeyInternal [in] - A parameter defining whether ephemeral 
*                         key internal or external
* @param EphemerPrivKeyIn_ptr [in] - A pointer to ephemeral private key.
* @param EphemerPrivKeySizeBytes [in] - A size (in bytes) of sender's ephemeral 
*                            private key data.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_EC_ELGAMAL_ENCR_INVALID_RECEIVER_PUBL_KEY_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_EPHEMERAL_KEY_IN_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_SIZE_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_ERROR
*
* \brief \b 
* Description:
*  This function make Elgamal encryption.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECPKI_ELGAMAL_Encrypt
*     for making of Elgamal encryption with using LibTomCrypt.
***************************************************************/ 
CE2CIMPORT_C CE2Error_t  CE2_DX_ECPKI_ELGAMAL_Encrypt (
					CE2_ECPKI_UserPublKey_t       *ReceiverUserPublKey_ptr, /*in*/
					DxUint8_t                      *MessageIn_ptr,           /*in*/
					DxUint32_t                      MessageInSizeBytes,      /*in*/
					DxUint8_t   				   *EncrMessageOut_ptr,      /*out*/
          DxUint32_t                 *EncrMessageOutSize_ptr,   /*in/out*/
				    DxInt8_t                        IsEphemerKeyInternal,    /*in*/
                    DxUint8_t                      *EphemerPrivKeyIn_ptr,    /*in*/ 
					DxUint32_t                      EphemerPrivKeySizeBytes /*in*/);


/**
****************************************************************
* Function Name: 
*  CE2_ECPKI_ELGAMAL_Encrypt
*
* Inputs:
* @param ReceiverUserPublKey_ptr [in] - A pointer to receiver public key 
*                           (key in little endian)
* @param MessageIn_ptr [in] - A pointer to message to be encrypted (message in big endian).
* @param MessageInSizeBytes [in] - A size of incoming message in bytes. The size must be
*                       MessageInSizeBytes =< ModulusSizeInBytes -  1.
*                       Note: in case CE2_ECPKI_DomainID_secp521r1 
*                       MessageInSizeBytes =< ModulusSizeInBytes -  2.
* @param EncrMessageOut_ptr [out] - A pointer to buffer for encrypted message.
* @param EncrMessageOutSize_ptr [in\out] - A pointer to output message size.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_EC_ELGAMAL_ENCR_INVALID_RECEIVER_PUBL_KEY_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_PTR_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_EPHEMERAL_KEY_IN_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_IN_SIZE_ERROR
*   - CE2_EC_ELGAMAL_ENCR_INVALID_MESSAGE_OUT_SIZE_ERROR
*
* \brief \b 
* Description:
*  CE2_ECPKI_ELGAMAL_Encrypt is the macro definition for calling the
*  _CE2_ECPKI_ELGAMAL_Encrypt function with internal generation of ephemeral keys
*
* \b 
* Algorithm:
*  Calls _CE2_ECPKI_ELGAMAL_Encrypt function with following arguments as constant: 
*   -# IsEphemerKeyInternal = DX_TRUE
*   -# EphemerKeyData_ptr = DX_NULL
*   -# EphemerPrivKeySizeBytes = 0
***************************************************************/ 
#define CE2_ECPKI_ELGAMAL_Encrypt(ReceiverUserPublKey_ptr,MessageIn_ptr,MessageInSizeBytes,EncrMessageOut_ptr, EncrMessageOutSize_ptr) \
	CE2_DX_ECPKI_ELGAMAL_Encrypt(ReceiverUserPublKey_ptr,MessageIn_ptr,MessageInSizeBytes,EncrMessageOut_ptr,EncrMessageOutSize_ptr, TRUE,DX_NULL,0)


/**
****************************************************************
* Function Name: 
*  CE2_ECPKI_ELGAMAL_Decrypt
*
* Inputs:
* @param ReceiverUserPrivKey_ptr [in] - A pointer to a receiver private key 
*                            structure (in affine coordinates).    				
* @param EncrMessageIn_ptr [in] - The user passed pointer to the encrypted 
*                      message buffer.
* @param EncrMessageSizeInBytes [in] - The size of input encrypted message. 
*                           Must be equal to 4*(EC modulus size in bytes)   
* @param DecrMessageOut_ptr [out] - The user passed pointer to buffer for output of  
*                       decrypted message.
* @param DecrMessageOutSize_ptr [in\out] - A pointer to size of uzer passed buffer 
*                          for decrypted message (in) and actual size 
*                          of decrypted message (out).
*                          Input value must be *DecrMessageOutSize_ptr >= 
*                         (EC modulus size in bytes) - 1. 
*                         Note: in case CE2_ECPKI_DomainID_secp521r1 input value must be 
*                         *DecrMessageOutSize_ptr >= (EC modulus size in bytes) - 2.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_EC_ELGAMAL_DECR_INVALID_RECEIVER_PRIV_KEY_PTR_ERROR
*   - CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_IN_PTR_ERROR
*   - CE2_EC_ELGAMAL_DECR_INVALID_DECR_MESSAGE_OUT_PTR_ERROR
*   - CE2_EC_ELGAMAL_DECR_INVALID_DECR_MESSAGE_OUT_SIZE_PTR_ERROR
*   - CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_IN_SIZE_ERROR
*   - CE2_EC_ELGAMAL_DECR_INVALID_ENCR_MESSAGE_OUT_SIZE_ERROR
*
* \brief \b 
* Description:
*  This function make Elgamal decryption.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECPKI_ELGAMAL_Decrypt
*     for making of Elgamal decryption with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t  CE2_ECPKI_ELGAMAL_Decrypt (			      
				CE2_ECPKI_UserPrivKey_t   *ReceiverUserPrivKey_ptr,  /*in*/	
			    DxUint8_t   		       *EncrMessageIn_ptr,        /*in*/
				DxUint32_t                  EncrMessageSizeInBytes,   /*in*/
			   	DxUint8_t		           *DecrMessageOut_ptr,       /*out*/
				DxUint32_t                 *DecrMessageOutSize_ptr   /*in/out*/);

/**********************************************************************************************************/


#ifdef __cplusplus
}
#endif			

#endif
